function CtfHUD::Init() {
	if ( $CtfHUD::Loaded )
		return;
	$CtfHUD::Loaded = true;
	
//	HUD::New::Shaded("CtfHUD::Container", 5, 80, 175, 40, CtfHUD::Wake, CtfHUD::Sleep);
	HUD::New::Shaded("CtfHUD::Container", 500, 8, 170, 72, CtfHUD::Wake, CtfHUD::Sleep);
	newObject("CtfHUD::Image0", FearGuiFormattedText, 0, 11, 20, 20); 
	newObject("CtfHUD::Image1", FearGuiFormattedText, 0, 42, 20, 20);

	newObject("CtfHUD::Status0", FearGuiFormattedText, 22, 10, 150, 20); 
	newObject("CtfHUD::Status1", FearGuiFormattedText, 22, 42, 150, 20);

	HUD::Add("CtfHUD::Container", "CtfHUD::Image0");
	HUD::Add("CtfHUD::Container", "CtfHUD::Image1");
	
	HUD::Add("CtfHUD::Container", "CtfHUD::Status0");
	HUD::Add("CtfHUD::Container", "CtfHUD::Status1");

	CtfHUD::Reset();
}

function CtfHUD::Wake() { CtfHUD::Update(); }
function CtfHUD::Sleep() { }

function CtfHUD::Reset() {
	Control::SetValue("CtfHUD::Image0", "<b0,0:Modules/CTFHud/friendly.home.png>");
	Control::SetValue("CtfHUD::Image1", "<b0,0:Modules/CTFHud/enemy.home.png>");

	CtfHUD::Update();
}

function CtfHUD::Update() {
	//friendly team goes in slot 0
	CtfHUD::SetTeamValue( 0, Team::Friendly() );
	//enemy team goes in slot 0
	CtfHUD::SetTeamValue( 1, Team::Enemy() );
}


function CtfHUD::SetTeamValue( %slot, %team ) {
	%score = Team::Score(%team);
	%loc = Team::Flag::Location(%team);
	
	switch ( %loc ) {
		case "home":
			%loc = "<f2>Home";
			break;
		case "field":
			%loc = "<f2>Dropped-><f2>" ~ Team::Flag::Timer(%team);
			break;
		default:
			%loc = "<f2>" ~ String::escapeFormatting(Client::GetName(%loc));
			break;
	}
	
	Control::SetValue( "CtfHUD::Status"~%slot, "<f1> <f2>"~%score~"<f1> -  "~%loc );


}

// if we change teams, the sides may need to be updated
function CtfHUD::SelfUpdate( %client, %team ) {
	if ( %client == getManagerId() )
		CtfHUD::Update();
}

Event::Attach( EventFlagUpdate, CtfHUD::Update );
Event::Attach( EventFlagTimerUpdate, CtfHUD::Update );
Event::Attach( EventClientChangeTeam, CtfHUD::SelfUpdate );

CtfHUD::Init();